/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.dialcfg;

import com.ibm.hwmca.base.rsf.BaseRsfErrorIds;
import com.ibm.hwmca.base.rsf.conndata.DunDialInfo;
import com.ibm.hwmca.base.rsf.conndata.Region;
import com.ibm.hwmca.base.rsf.dialcfg.DialAddBean;
import com.ibm.hwmca.base.rsf.dialcfg.DialConfigActions;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.Map;

public class DialConfigBean
extends PanelBean
implements BaseRsfErrorIds,
DialConfigActions {
    private static final String TRACE_MASKT = "HMRSBENT";
    private static final String TRACE_MASKF = "HMRSBENF";
    private static final String TRACE_MASKD = "HMRSBEND";
    private static final int MAX_NUMBERS = 8;
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-89, "DialCfgBean");
    private transient boolean changed = false;
    private transient boolean busy;
    private transient int selection;
    private Region[] countryList;
    private Region[] regionList;
    private int configuredCount;
    private DunDialInfo[] numberList;
    private DunDialInfo[] configuredList;
    private DunDialInfo[] regionalList;
    private String originCountryChoice;
    private String countryChoice;
    private String regionChoice;
    private int[] dialTableSelection;
    private int[] phoneTableSelection;

    public String getOriginRegionChoice() {
        return this.originCountryChoice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOriginRegionChoice(String s) throws IllegalUserDataException {
        if (s.equals(this.originCountryChoice)) {
            return;
        }
        if (this.userTaskManager == null) {
            this.changed = true;
            this.originCountryChoice = s;
            return;
        }
        DialConfigBean dialConfigBean = this;
        synchronized (dialConfigBean) {
            if (!this.isBusy()) {
                this.setBusy(true);
                this.changed = true;
                this.originCountryChoice = s;
                try {
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setData("source", "config");
                    request.setData("action", "update_regional_list");
                    request.setData("origin", Region.findRegionByName(this.countryList, this.originCountryChoice));
                    this.postTaskletRequest(request);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public ValueDescriptor[] getOriginRegionChoiceList() {
        ValueDescriptor[] values;
        if (this.originCountryChoice.equals("")) {
            values = new ValueDescriptor[this.countryList.length + 1];
            values[this.countryList.length] = new ValueDescriptor(null, "");
        } else {
            values = new ValueDescriptor[this.countryList.length];
        }
        int i = 0;
        while (i < this.countryList.length) {
            values[i] = new ValueDescriptor(null, this.countryList[i].getName());
            ++i;
        }
        return values;
    }

    public int getDialTableRowStatus() {
        return 3;
    }

    public int getDialTableRowCount() {
        if (this.configuredCount == 0 && this.regionalList.length == 0) {
            return 1;
        }
        if (this.regionalList.length == 0) {
            return this.configuredCount;
        }
        return this.configuredCount + this.regionalList.length + 1;
    }

    public ItemDescriptor[] getDialTableRowAt(int index) {
        ItemDescriptor[] items = new ItemDescriptor[2];
        if (this.configuredCount == 0 && this.regionalList.length == 0) {
            items[0] = new ItemDescriptor(null, "");
            items[1] = new ItemDescriptor(null, "(No Numbers)");
        } else if (index < this.configuredCount) {
            items[0] = new ItemDescriptor(null, String.valueOf(index + 1));
            items[1] = new ItemDescriptor(null, this.configuredList[index].getConfiguredNumber());
        } else if (index == this.configuredCount) {
            items[0] = new ItemDescriptor(null, "");
            items[1] = new ItemDescriptor(null, "(Backup Numbers)");
        } else {
            items[0] = new ItemDescriptor(null, String.valueOf((index -= this.configuredCount + 1) + this.configuredCount + 1));
            items[1] = new ItemDescriptor(null, this.regionalList[index].getConfiguredNumber());
        }
        return items;
    }

    public int[] getDialTableSelection() {
        return this.dialTableSelection;
    }

    public void setDialTableSelection(int[] selected) throws IllegalUserDataException {
        this.dialTableSelection = selected;
    }

    public String getRegionChoice() {
        return this.countryChoice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegionChoice(String s) throws IllegalUserDataException {
        if (s.equals(this.countryChoice)) {
            return;
        }
        if (this.userTaskManager == null) {
            this.changed = true;
            this.countryChoice = s;
            return;
        }
        DialConfigBean dialConfigBean = this;
        synchronized (dialConfigBean) {
            if (!this.isBusy()) {
                this.setBusy(true);
                this.changed = true;
                this.countryChoice = s;
                try {
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setData("source", "config");
                    request.setData("action", "update_regions");
                    request.setData("country", Region.findRegionByName(this.countryList, this.countryChoice));
                    this.postTaskletRequest(request);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public ValueDescriptor[] getRegionChoiceList() {
        ValueDescriptor[] values;
        if (this.countryChoice.equals("")) {
            values = new ValueDescriptor[this.countryList.length + 1];
            values[this.countryList.length] = new ValueDescriptor(null, "");
        } else {
            values = new ValueDescriptor[this.countryList.length];
        }
        int i = 0;
        while (i < this.countryList.length) {
            values[i] = new ValueDescriptor(null, this.countryList[i].getName());
            ++i;
        }
        return values;
    }

    public String getStateProvinceChoice() {
        return this.regionChoice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStateProvinceChoice(String s) throws IllegalUserDataException {
        if (s.equals(this.regionChoice)) {
            return;
        }
        if (this.userTaskManager == null) {
            this.changed = true;
            this.regionChoice = s;
            return;
        }
        DialConfigBean dialConfigBean = this;
        synchronized (dialConfigBean) {
            if (!this.isBusy()) {
                this.setBusy(true);
                this.changed = true;
                this.regionChoice = s;
                try {
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setData("source", "config");
                    request.setData("action", "update_number_list");
                    request.setData("country", Region.findRegionByName(this.countryList, this.countryChoice));
                    request.setData("region", Region.findRegionByName(this.regionList, this.regionChoice));
                    this.postTaskletRequest(request);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public ValueDescriptor[] getStateProvinceChoiceList() {
        ValueDescriptor[] values = new ValueDescriptor[this.regionList.length];
        int i = 0;
        while (i < this.regionList.length) {
            values[i] = new ValueDescriptor(null, this.regionList[i].getName());
            ++i;
        }
        return values;
    }

    public int getPhoneTableRowStatus() {
        return 3;
    }

    public int getPhoneTableRowCount() {
        return this.numberList.length;
    }

    public ItemDescriptor[] getPhoneTableRowAt(int index) {
        ItemDescriptor[] items = new ItemDescriptor[]{new ItemDescriptor(null, this.numberList[index].getBaseNumber()), new ItemDescriptor(null, this.numberList[index].getDescription())};
        return items;
    }

    public int[] getPhoneTableSelection() {
        return this.phoneTableSelection;
    }

    public void setPhoneTableSelection(int[] selected) throws IllegalUserDataException {
        this.phoneTableSelection = selected;
    }

    public boolean isBusy() {
        Trace.trace(TRACE_MASKT, this.busy + " <- isBusy()");
        return this.busy;
    }

    public void setBusy(boolean busy) {
        Trace.trace(TRACE_MASKT, "-> setBusy(" + busy + ")");
        this.busy = busy;
        Trace.trace(TRACE_MASKT, "<- setBusy()");
    }

    public void setCountries(Region[] countryList) {
        this.countryList = countryList;
    }

    public void setRegions(Region[] regionList) {
        this.regionList = regionList;
    }

    public DunDialInfo[] getConfiguredNumbers() {
        DunDialInfo[] numbers = new DunDialInfo[this.configuredCount];
        int i = 0;
        while (i < this.configuredCount) {
            numbers[i] = this.configuredList[i];
            ++i;
        }
        return numbers;
    }

    public void setConfiguredList(DunDialInfo[] numbers) {
        this.configuredCount = 0;
        this.configuredList = new DunDialInfo[8];
        int i = 0;
        while (i < numbers.length) {
            if (!numbers[i].isMultiRegionNumber() && this.configuredCount < 8) {
                this.configuredList[this.configuredCount++] = numbers[i];
            }
            ++i;
        }
    }

    public void setNumberList(DunDialInfo[] numbers) {
        this.numberList = numbers;
    }

    public DunDialInfo[] getRegionalList() {
        return this.regionalList;
    }

    public void setRegionalList(DunDialInfo[] numbers) {
        this.regionalList = numbers;
        int i = 0;
        while (i < this.regionalList.length) {
            this.regionalList[i].setMultiRegionNumber();
            ++i;
        }
    }

    public DunDialInfo[] getAllNumbers() {
        DunDialInfo[] numbers = new DunDialInfo[this.configuredCount + this.regionalList.length];
        int i = 0;
        while (i < this.configuredCount) {
            numbers[i] = this.configuredList[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.regionalList.length) {
            numbers[this.configuredCount + i2] = this.regionalList[i2];
            ++i2;
        }
        return numbers;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void load() {
        this.changed = false;
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object updateInfo) {
        Trace.trace(TRACE_MASKT, "-> update(" + updateInfo + ")");
        try {
            Map data = (Map)updateInfo;
            String action = (String)data.get("action");
            if (action.equals("update_number")) {
                DialAddBean bean = (DialAddBean)data.get("bean");
                String mode = bean.getMode();
                if (mode.equals("add_number")) {
                    String configuredNumber = bean.getVariationGBSelection()[0].equals("OriginalChoice") ? bean.getOriginalChoice() : bean.getCustomChoiceEdit();
                    this.configuredList[this.configuredCount++] = new DunDialInfo(configuredNumber, this.numberList[this.selection].getBaseNumber(), this.numberList[this.selection].getCountry(), this.numberList[this.selection].getRegion(), this.numberList[this.selection].getDescription(), "", false);
                    this.setDialTableSelection(null);
                } else if (mode.equals("add_custom")) {
                    String configuredNumber = bean.getCustomChoiceEdit();
                    this.configuredList[this.configuredCount++] = new DunDialInfo(configuredNumber, "", "  ", "  ", "Custom Number", "", false);
                    this.setDialTableSelection(null);
                } else if (mode.equals("edit_number")) {
                    String configuredNumber = bean.getVariationGBSelection()[0].equals("OriginalChoice") ? bean.getOriginalChoice() : bean.getCustomChoiceEdit();
                    this.configuredList[this.selection] = new DunDialInfo(configuredNumber, this.configuredList[this.selection].getBaseNumber(), this.configuredList[this.selection].getCountry(), this.configuredList[this.selection].getRegion(), this.configuredList[this.selection].getDescription(), "", false);
                }
            } else if (action.equals("update_regional_list")) {
                this.setRegionalList((DunDialInfo[])data.get("numbers"));
            } else if (action.equals("update_regions")) {
                this.setRegions((Region[])data.get("regions"));
                this.setStateProvinceChoice(((Region)data.get("region")).getName());
                this.setNumberList((DunDialInfo[])data.get("numbers"));
                this.setPhoneTableSelection(null);
            } else if (action.equals("update_number_list")) {
                this.setNumberList((DunDialInfo[])data.get("numbers"));
                this.setPhoneTableSelection(null);
            } else if (action.equals("cancel")) {
                // empty if block
            }
            this.userTaskManager.refreshAllElements();
            DialConfigBean dialConfigBean = this;
            synchronized (dialConfigBean) {
                this.setBusy(false);
            }
        }
        catch (Exception e) {
            new FrameworkLog(logInfo, 4103, e).log();
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- update()");
    }

    public void save() {
    }

    public void verifyChanges() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelAction(TaskActionEvent event) {
        block36: {
            Trace.trace(TRACE_MASKT, "-> panelAction(" + event + ")");
            try {
                String element = event.getElementName();
                Trace.trace(TRACE_MASKT, "element = " + element);
                if (element.equals(this.getMountPrefix() + "OkButton")) {
                    this.userTaskManager.storeAllElements();
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setData("source", "config");
                    request.setData("action", "commit");
                    request.setData("bean", this);
                    this.postTaskletRequest(request);
                    break block36;
                }
                if (element.equals(this.getMountPrefix() + "MoveUpButton")) {
                    this.userTaskManager.storeAllElements();
                    if (this.getDialTableSelection() == null || this.getDialTableSelection().length == 0) {
                        return;
                    }
                    int index = this.getDialTableSelection()[0];
                    if (index == 0 || index >= this.configuredCount) {
                        return;
                    }
                    DunDialInfo buffer = this.configuredList[index];
                    this.configuredList[index] = this.configuredList[index - 1];
                    this.configuredList[index - 1] = buffer;
                    this.setDialTableSelection(new int[]{index - 1});
                    this.userTaskManager.refreshElement(this.getMountPrefix() + "DialTable");
                    this.changed = true;
                    break block36;
                }
                if (element.equals(this.getMountPrefix() + "MoveDownButton")) {
                    this.userTaskManager.storeAllElements();
                    if (this.getDialTableSelection() == null || this.getDialTableSelection().length == 0) {
                        return;
                    }
                    int index = this.getDialTableSelection()[0];
                    if (index >= this.configuredCount - 1) {
                        return;
                    }
                    DunDialInfo buffer = this.configuredList[index];
                    this.configuredList[index] = this.configuredList[index + 1];
                    this.configuredList[index + 1] = buffer;
                    this.setDialTableSelection(new int[]{index + 1});
                    this.userTaskManager.refreshElement(this.getMountPrefix() + "DialTable");
                    this.changed = true;
                    break block36;
                }
                if (element.equals(this.getMountPrefix() + "EditButton")) {
                    this.userTaskManager.storeAllElements();
                    DialConfigBean index = this;
                    synchronized (index) {
                        if (!this.isBusy()) {
                            if (this.getDialTableSelection() == null || this.getDialTableSelection().length == 0) {
                                return;
                            }
                            this.selection = this.getDialTableSelection()[0];
                            if (this.selection >= this.configuredCount) {
                                return;
                            }
                            DialAddBean bean = new DialAddBean();
                            bean.setMode("edit_number");
                            bean.setOriginalChoice(this.configuredList[this.selection].getBaseNumber());
                            bean.setCustomChoiceEdit(this.configuredList[this.selection].getConfiguredNumber());
                            PanelTaskletRequest request = new PanelTaskletRequest();
                            request.setData("source", "config");
                            request.setData("action", "add_number");
                            request.setData("bean", bean);
                            this.setBusy(true);
                            this.postTaskletRequest(request);
                        }
                        break block36;
                    }
                }
                if (element.equals(this.getMountPrefix() + "RemoveButton")) {
                    this.userTaskManager.storeAllElements();
                    if (this.getDialTableSelection() == null || this.getDialTableSelection().length == 0) {
                        return;
                    }
                    int index = this.getDialTableSelection()[0];
                    if (index >= this.configuredCount) {
                        return;
                    }
                    int i = index;
                    while (i < this.configuredCount - 1) {
                        this.configuredList[i] = this.configuredList[i + 1];
                        ++i;
                    }
                    --this.configuredCount;
                    this.setDialTableSelection(null);
                    this.userTaskManager.refreshElement(this.getMountPrefix() + "DialTable");
                    this.changed = true;
                    break block36;
                }
                if (element.equals(this.getMountPrefix() + "AddSelectedButton")) {
                    DialConfigBean index = this;
                    synchronized (index) {
                        if (!this.isBusy()) {
                            if (this.configuredCount == 8) {
                                return;
                            }
                            this.userTaskManager.storeAllElements();
                            if (this.getPhoneTableSelection() == null || this.getPhoneTableSelection().length == 0) {
                                return;
                            }
                            this.selection = this.getPhoneTableSelection()[0];
                            DialAddBean bean = new DialAddBean();
                            bean.setMode("add_number");
                            bean.setOriginalChoice(this.numberList[this.selection].getBaseNumber());
                            bean.setCustomChoiceEdit(this.numberList[this.selection].getConfiguredNumber());
                            PanelTaskletRequest request = new PanelTaskletRequest();
                            request.setData("source", "config");
                            request.setData("action", "add_number");
                            request.setData("bean", bean);
                            this.setBusy(true);
                            this.postTaskletRequest(request);
                        }
                        break block36;
                    }
                }
                if (element.equals(this.getMountPrefix() + "AddCustomButton")) {
                    DialConfigBean index = this;
                    synchronized (index) {
                        if (!this.isBusy()) {
                            if (this.configuredCount == 8) {
                                return;
                            }
                            DialAddBean bean = new DialAddBean();
                            bean.setMode("add_custom");
                            bean.setOriginalChoice("");
                            bean.setCustomChoiceEdit("");
                            PanelTaskletRequest request = new PanelTaskletRequest();
                            request.setData("source", "config");
                            request.setData("action", "add_number");
                            request.setData("bean", bean);
                            this.setBusy(true);
                            this.postTaskletRequest(request);
                        }
                        break block36;
                    }
                }
                if (element.equals(this.getMountPrefix() + "CancelButton")) {
                    boolean ans;
                    this.userTaskManager.storeAllElements();
                    if (this.changed && !(ans = CommonMsgApp.showDataChangedConfirmation(this.userTaskManager))) {
                        Trace.trace(TRACE_MASKF, "throw IllegalUserDataException <- panelAction()");
                        throw new IllegalUserDataException();
                    }
                    this.dispose();
                }
            }
            catch (IllegalUserDataException e) {
                throw e;
            }
            catch (Exception e) {
                new FrameworkLog(logInfo, 4102, e).log();
                this.dispose();
            }
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }
}

